class ShowDamage extends Mutator;

var int currentDamage[1024];

var ShowDamageInfo I;
var bool preInit;
var bool postInit;
var bool detailLog;

// Called before play :)
event PreBeginPlay()
{
	
	if (preInit)
		return;
	preInit = True;

	if (detailLog)
		log("Mutator ShowDamage: PreBeginPlay(): I'm here!");
	
	// thpawn our info
	I = Spawn(class'ShowDamage.ShowDamageInfo');
	if (I == None) // play thafe
	{
		log("Mutator ShowDamage: PreBeginPlay(): I is None. ShowDamageInfo spawning failed. This mutator is likely not to work.");
		return;
	}
	
	if (Spawn(class'ShowDamage.ShowDamageNotify') == None)
		log("Mutator ShowDamage: PreBeginPlay(): ShowDamageNotify ShowDamageInfo spawning failed. This mutator is likely not to work.");
}

function PostBeginPlay()
{
	if (postInit)
		return;
	postInit = True;

	Level.Game.RegisterDamageMutator(Self);
}

// Regithter all damage taken and given.
function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	local int victimId;
	local int shoterId;

	I.totalDamageInGame += ActualDamage;

	// Only count damage inflicted by playerth on playerth. Altho dont count damage
	// inflicted by ithelf. It lookth too ugly. We only count the damage that lookth
	// nice on the info thlot...
	if (Victim != None && InstigatedBy != None && Victim != InstigatedBy)
	{
		// We wanth id:th!
		victimId = Victim.PlayerReplicationInfo.PlayerID;
		shoterId = InstigatedBy.PlayerReplicationInfo.PlayerID;

		// Thith ith the heart
		currentDamage[shoterId + (victimId << 5)] += ActualDamage;

		// Thethe make the playerth happy...
		I.totalDamageGot[victimId] += ActualDamage;
		I.totalDamageDone[shoterId] += ActualDamage;

		// They really wanth to know, you know...
		I.lastTarget[shoterId] = Victim;
		I.lastAttacker[victimId] = InstigatedBy;

		// Every detail, almotht. almosth...
		I.lastDamageMe[shoterId] = currentDamage[victimId + (shoterId << 5)];
		I.lastDamage[shoterId] = currentDamage[shoterId + (victimId << 5)];

		// almoth yeth.
		I.lastADamageMe[victimId] = currentDamage[shoterId + (victimId << 5)];
		I.lastADamage[victimId] = currentDamage[victimId + (shoterId << 5)];
	}

	// Are there any more thingyth out there who wanth to be informed??
	if ( NextDamageMutator != None )
		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

// Look up and regithter/rethet playerth damageinfo
function ModifyPlayer(Pawn Other)
{
	local int id;
	local int j;

	if (detailLog)
		log("Mutator ShowDamage: ModifyPlayer(): I'm here!");
	
	id = Other.PlayerReplicationInfo.PlayerID;

	// Check if the player ith new
	if (I != None && (I.players[id] == None || I.players[id] != Other))
	{ 
		log("Mutator ShowDamage: ModifyPlayer(): New player detected. Name: " $ Other.PlayerReplicationInfo.PlayerName $ ", ID: " $ String(id));

		// Player ith new, rethet everything involving it...
		I.players[id] = Other;
		I.lastTarget[id] = None;
		I.lastAttacker[id] = None;
		I.lastDamageMe[id] = 0;
		I.lastDamage[id] = 0;
		I.lastADamageMe[id] = 0;
		I.lastADamage[id] = 0;
		I.totalDamageDone[id] = 0;
		I.totalDamageGot[id] = 0;

		for (j = 0; j < 32; j++)
		{
			currentDamage[(j << 5) + id] = 0;
			currentDamage[j + (id << 5)] = 0;
		}
	}
	else
		// Player isn't new, only rethet current damage inflicted to it
		for (j = 0; j < 32; j++)
			currentDamage[j + (id << 5)] = 0;
	
	// Any more?
	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}


defaultproperties
{	// Do we want doeth ugly "im here"-logth"??
	detailLog=False
}

// That'th it. Drawing ith up to ThowDamageHUD
